
#ifndef REFLECTION_H
#define REFLECTION_H
#include "lrt.h"
#include "geometry.h"

#define GAP 1

class BRDF {
  public:

	virtual ~ BRDF();

	virtual Spectrum fr(const Vector & wi) const = 0;

	virtual int SpecularComponents() const;

	virtual Spectrum SampleSpecular(int component, Vector * wo) const;

	virtual Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const =
		0;

	virtual Float Pdf(const Vector & wi) const = 0;

};

class Lambertian:public BRDF { public:
	 Lambertian(const Spectrum & reflectance, const Normal & normal) {
		R = reflectance;
		N = normal;
	} Spectrum fr(const Vector & wi) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;

	Float Pdf(const Vector & wi) const;

  private:

	Spectrum R;
	Normal N;

};

class BlinnGlossy:public BRDF { public:
	 BlinnGlossy(const Spectrum & reflectance, Float roughness,
				 const Normal & normal, const Vector & wo);

	Spectrum fr(const Vector & wi) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;

	Float Pdf(const Vector & wi) const;

  private:
	 Spectrum R;
	Float invRoughness;
	Vector wo;
	Normal N;
	Float costhetao;

};

class SpecularReflection:public BRDF { public:
	
		SpecularReflection(const Spectrum & r, const Normal & N,
						   const Vector & wi);

	Spectrum fr(const Vector &) const {
		return Spectrum(0.);
	} int SpecularComponents() const {
		return 1;
	} Spectrum SampleSpecular(int component, Vector * wi) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const {
		*pdf = 0.;
		return Spectrum(0.);
	} Float Pdf(const Vector & wi) const {
		return 0.;
  } private:

	 Spectrum R;
	Vector reflectedDirection;

};

class SpecularTransmission:public BRDF {
  public:

	SpecularTransmission(const Spectrum & r, const Normal & N,
						 const Vector & wo, Float indexi, Float indext);

	Spectrum fr(const Vector & wi) const {
	/* If the direction of the light (wi) is the same as the direction
		of transmission, then return the spectrum. Otherwise, return 0.
	*/
		if (R.monochromatic == 1) {
			Float diff = Dot(wi, DirT[R.wave_bucket]);
			if (fabs(1.0 - fabs(diff)) < 0.001) return R;
		} else if (R.monochromatic == 2) {
			for (int i = 0; i < SPEC; i += GAP) {
				Float diff = Dot(wi, DirT[i]);
				if (fabs(1.0 - fabs(diff)) < 0.001) {
					Spectrum newSpec = Spectrum(R, i * 5);
					newSpec.spectrum_to_rgb();
					newSpec.constrain_rgb();
					return newSpec;
				}
			}
		}
		return Spectrum(0.);
	} int SpecularComponents() const {
		return num_split;
	} Spectrum SampleSpecular(int component, Vector * wo) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const {
		*pdf = 0.;
		return Spectrum(0.);
	} Float Pdf(const Vector & wi) const {
		return 0.;
  } private:

	 Spectrum R;
	int num_split;
	Vector DirT[SPEC];

};

class ScatteringMixture:public BRDF {
  public:

	ScatteringMixture():numSpecular(0) {
	} void AddFunction(BRDF * func, Float weight = 1.0) {
		funcs.push_back(func);
		weights.push_back(weight);
		numSpecular += func->SpecularComponents();
	} ~ScatteringMixture();

	int SpecularComponents() const {
		return numSpecular;
	} Spectrum fr(const Vector & wi) const;

	Spectrum SampleSpecular(int component, Vector * wo) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;

	Float Pdf(const Vector & wi) const;

  private:

	vector < BRDF * >funcs;
	vector < Float > weights;
	int numSpecular;

};

#if 0
class Lafortune:public BRDF { public:
	 Lafortune(int nLobes, const LafortuneLobe lobes[], const Vector & wi,
			   const Normal & N, const Vector & dPdu);

	~Lafortune() {
		delete[]lobes;
	} Spectrum fr(const Vector &) const;

  private:

	int nLobes;
	LafortuneLobe *lobes;
	Normal N;
	Vector wo;
	Vector dPdu, dPdv;

};
#endif

#endif // REFLECTION_H
