#include "lrt.h"
#include "primitives.h"
#include "color.h"
#include "light.h"
#include "scene.h"
#include "reflection.h"
#include "sampling.h"
#include "materials.h"
#include "transport.h"
Integrator::~Integrator() {
}
Spectrum RayCastingIntegrator::L(const Scene *scene,
		const Ray &ray, Float *alpha) const {
	Surf surf;
	if (scene->Intersect(ray, &surf)) {
		Spectrum L(0.);
		if (alpha) *alpha = 1.;
		L += surf.Le(-ray.D);
		BSDF *bsdf = surf.getBSDF();
		Vector wi;
		for (u_int i = 0; i < scene->lights.size(); ++i) {
			Spectrum dE = scene->lights[i]->dE(scene, surf.dgShading, &wi);
			L += bsdf->f(-ray.D, wi) * dE;
		}
		delete bsdf;
		return L;
	}
	else {
		if (alpha) *alpha = 0.;
		return Spectrum(0.);
	}
}
Spectrum WhittedIntegrator::L(const Scene *scene, const Ray &ray,
		Float *alpha) const {
	Surf surf;

	if (scene->Intersect(ray, &surf)) {
		Spectrum L(0.);
		if (alpha) *alpha = 1.;
		L += surf.Le(-ray.D);
		BSDF *bsdf = surf.getBSDF();
		Vector wi;
		for (u_int i = 0; i < scene->lights.size(); ++i) {
			Spectrum dE = scene->lights[i]->dE(scene, surf.dgShading, &wi);
			L += bsdf->f(-ray.D, wi) * dE;
		}
		if (++RayDepth < MaxDepth) {
			for (int i = 0; i < bsdf->NumSpecular(); ++i) {
				Spectrum fr = bsdf->f_delta(i, -ray.D, &wi);
				if (fr != Spectrum(0.))
					L += scene->L(Ray(surf.dgShading.P, wi)) * fr;
			}
		}
		--RayDepth;
		delete bsdf;
		return L;
	}
	else {
		if (alpha) *alpha = 0.;
		return Spectrum(0.);
	}
}
int WhittedIntegrator::RayDepth = 0;
Spectrum PathIntegrator::L(const Scene *scene,
		const Ray &r, Float *alpha) const {
	Spectrum pathWeight = 1.;
	Spectrum L = 0.;
	Ray ray = r;
	if (alpha) *alpha = 1.;
	int pathLength = 0;
	while (1) {
		Surf surf;
		if (!scene->Intersect(ray, &surf)) {
			if (pathLength == 0 && alpha) *alpha = 0.;
			break;
		}
		if (pathLength == 0)
			L += surf.Le(-ray.D);
		BSDF *bsdf = surf.getBSDF();
		Vector wi;
		Float weight;
		int lightNum = int(RandomFloat() * scene->lights.size());
		const Light *light = scene->lights[lightNum];
		Spectrum dE = light->sample_dE(scene,
			surf.dgShading, &wi, &weight);
		L += pathWeight * weight * bsdf->f(-ray.D, wi) * dE;
		Spectrum f = bsdf->sample_f(-ray.D, &wi);
		weight = bsdf->weight(-ray.D, wi);
		if (f == Spectrum(0.) || weight == 0.)
			break;
		pathWeight *= f * weight * fabs(Dot(wi.Hat(), surf.dgShading.N.Hat()));
		ray = Ray(surf.dgGeom.P, wi);
		delete bsdf;
		if (pathLength > 3 && pathWeight.Intensity() < .1) {
			Float rrProbability = .8;
			if (RandomFloat() < rrProbability)
				break;
			pathWeight /= 1. - rrProbability;
		}
		++pathLength;
	}
	return L;
}
Spectrum MCIntegrator::L(const Scene *scene,
		const Ray &r, Float *alpha) const {
	Spectrum pathWeight = 1.;
	Spectrum L = 0.;
	Ray ray = r;
	if (alpha) *alpha = 1.;
	int pathLength = 0;
	while (1) {
		Surf surf;
		if (!scene->Intersect(ray, &surf)) {
			if (pathLength == 0 && alpha) *alpha = 0.;
			break;
		}
		BSDF *bsdf = surf.getBSDF();
		Vector wi;
		Float weight, lightWeight, bsdfWeight;
		int lightNum = int(RandomFloat() * scene->lights.size());
		const Light *light = scene->lights[lightNum];
		Spectrum dE = light->sample_dE(scene,
			surf.dgShading, &wi, &lightWeight);
		bsdfWeight = bsdf->weight(-ray.D, wi);
		weight = .5 * lightWeight + .5 * bsdfWeight;
		L += pathWeight * weight * bsdf->f(-ray.D, wi) * dE;
		Spectrum f = bsdf->sample_f(-ray.D, &wi);
		bsdfWeight = bsdf->weight(-ray.D, wi);
		lightWeight = 0;
		for (u_int i = 0; i < scene->lights.size(); ++i)
			lightWeight += scene->lights[i]->weight(surf.dgGeom.P, wi);
		lightWeight /= scene->lights.size();
		weight = .5 * lightWeight + .5 * bsdfWeight;
		if (f == Spectrum(0.) || weight == 0.)
			break;
		pathWeight *= f * weight * fabs(Dot(wi.Hat(), surf.dgShading.N.Hat()));
		ray = Ray(surf.dgGeom.P, wi);
		delete bsdf;
		if (pathLength > 3 && pathWeight.Intensity() < .1) {
			Float rrProbability = .8;
			if (RandomFloat() < rrProbability)
				break;
			pathWeight /= 1. - rrProbability;
		}
		++pathLength;
	}
	return L;
}

Spectrum PhotonIntegrator::L(const Scene *scene, const Ray &ray, Float *alpha) const
{
	Surf s;
	Spectrum L(0.0);
	if (scene->Intersect(ray,&s)) {
		float ir[3];
		float cr[3];
		float ind[3];
		float env[3];
		env[0]=env[1]=env[2]=0.f;
		float temp[3];
		if (alpha) *alpha = 1.;
		scene->pmap->GetIrradiance(ir,s.dgGeom.P,s.dgGeom.N,50.0f,1000);
		scene->cmap->GetIrradiance(cr,s.dgGeom.P,s.dgGeom.N,25.0f,1000);
		scene->imap->GetIrradiance(ind,s.dgGeom.P,s.dgGeom.N,100.0f,1000);

//#ifdef VOLUMETRICS

		float d = sqrt(ray.D.x*ray.D.x+ray.D.y*ray.D.y+ray.D.z*ray.D.z);
		float step = 10.0/d;
		for (float t = ray.mint+step/2; t<ray.maxt;t+=step) {
			scene->envmap->GetIrradiance(temp,ray(t),(Normal)-ray.D.Hat(), 10.0f,1000);
			env[0]+=temp[0];
			env[1]+=temp[1];
			env[2]+=temp[2];
		}
		L+=Spectrum(env[0],env[1],env[2]);

//#endif

		ir[0]+=cr[0];
		ir[1]+=cr[1];
		ir[2]+=cr[2];
		ir[0]+=ind[0];
		ir[1]+=ind[1];
		ir[2]+=ind[2];



	   	L += s.Le(-ray.D);
		BSDF *bsdf = s.getBSDF();
		Vector wi;
		Spectrum dE(ir[0],ir[1],ir[2]);
//		Spectrum S = bsdf->sample_f(ray.D, &wi);
	//	printf("\n");
		for (u_int i = 0; i < scene->lights.size(); ++i) {
			scene->lights[i]->dE(scene, s.dgShading, &wi);
			bsdf->f(-ray.D, wi);
			L += bsdf->f(-ray.D, wi) * dE;
		}



//		L += dE*S;
		//L += bsdf->f(-ray.D, wi) * dE;
		//L.ConvertToRGB(ir);
	 // 	printf("\nHit %f %f %f %f %f %f",s.dgGeom.P.x,s.dgGeom.P.y,s.dgGeom.P.z,ir[0],ir[1],ir[2]);
		//L = integrator->L(this, ray, &alpha);

		if (++PhotonDepth < MaxDepth) {
			for (int i = 0; i < bsdf->NumSpecular(); ++i) {
				Spectrum fr = bsdf->f_delta(i, -ray.D, &wi);
				if (fr != Spectrum(0.))
					L += scene->L(Ray(s.dgShading.P, wi)) * fr;
			}
		}
		--PhotonDepth;
		delete bsdf;
	} else {
		if (alpha) *alpha = 0.;
		L = Spectrum(0);
	}
	return L;
}
int PhotonIntegrator::PhotonDepth = 0;