/* CS348C PROGRAMMING ASSIGNMENT 1: PARAMETRIC POLYNOMIAL CURVES.

Copyright (c) 1995 The Board of Trustees of The Leland Stanford Junior
University. All rights reserved.

Permission to use, copy, modify and distribute this software for any
purpose is hereby granted without fee, provided that the above
copyright notice and this permission notice appear in all copies of
this software and that you do not sell the software.  Commercial
licensing is available by contacting the author.

THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT WARRANTY OF ANY KIND,
EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.

Author:
   Apostolos Lerios
   Computer Science Department
   Stanford University
   U.S.A.
   http://graphics.stanford.edu/~tolis/ */


/* TYPES. */

/* A point in 3D space. */

typedef double Point[3];


/* FUNCTION DECLARATIONS. */

/* C++ linkage convention established, if and only if you use C++. */

#ifdef __cplusplus
extern "C" {
#endif

/* InitSystem() is called once and only once during the execution of
   "polly". It provides the curve drawing module "draw.c" with an
   opportunity to perform initialization, such as building caches, or
   opening trace files; also, it supplies basic system parameters,
   whose values will not change throughout "polly"'s execution. These
   parameters comprise the number of control points PointCount
   (guaranteed to be no less than two), and a pointer to the list of
   control points named ControlP. In more detail, ControlP points to
   the first element of an array containing a total of PointCount
   elements.

   NOTE: the contents of this array DO change over time (as the user
   interactively moves control points); however, the array is always
   stored in the SAME portion of memory. */

void InitSystem(int PointCount,
		Point *ControlP);

/* GetCurvePoint() is called every time the user interface module
   "polly.c++" needs the coordinates of a point on the curve. In
   particular, GetCurvePoint() is given the parameter value of
   interest t, and is expected to place in P the associated curve
   point. Bezier is a binary flag: when set (1), the user-defined
   control points are the Bezier points of the curve; when cleared
   (0), the curve must pass through the control points at equally
   spaced parameter values (an interpolating curve). The
   parameterization of the curve is such that it passes through the
   first control point at t=0, and through the last control point at
   t=1. */

void GetCurvePoint(int Bezier,
		   double t,
		   Point P);

/* Cleanup() is called once and only once during the execution of
   "polly", right before "polly" terminates. It provides the curve
   drawing module "draw.c" with an opportunity to perform cleanup of
   its local resources, such as deallocating cache memory or closing
   trace files. */

void Cleanup(void);

#ifdef __cplusplus
}
#endif
