/* CS348C PROGRAMMING ASSIGNMENT 1: SIMPLIFIED MOTIF INTERFACE.

Copyright (c) 1995 The Board of Trustees of The Leland Stanford Junior
University. All rights reserved.

Permission to use, copy, modify and distribute this software for any
purpose is hereby granted without fee, provided that the above
copyright notice and this permission notice appear in all copies of
this software and that you do not sell the software.  Commercial
licensing is available by contacting the author.

THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT WARRANTY OF ANY KIND,
EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.

Author:
   Apostolos Lerios
   Computer Science Department
   Stanford University
   U.S.A.
   http://graphics.stanford.edu/~tolis/ */


#ifndef XSUPPORT_H
#define XSUPPORT_H


#include "X11/Intrinsic.h"


/* PUSH BUTTON. */

typedef void (*PushButtonCallback)(void *);

class PushButton {

 private:

  PushButtonCallback Callback;
  void *UserData;

 public:

  /* Creates a push button as a child of the Parent widget. Name is
     the label that appears within the button. NewCallback is a void
     function with one argument that is called whenever the button is
     activated: the argument given to NewCallback is NewUserData. */

  PushButton(Widget Parent, char *Name,
	     PushButtonCallback NewCallback, void *NewUserData =0);

  friend void PushButtonPrecallback(Widget, PushButton *, void *);
};


/* FILE DIALOG PUSH BUTTON. */

typedef void (*DialogButtonCallback)(char *);

class DialogButton {

 public:

  /* Creates a dialog button as a child of the Parent widget. Name is
     the label that appears within the button. When the button is
     pressed, a file selection dialog appears, asking the user to
     select a file.  Message is the string that appears next to the
     file selection prompt.  Callback is a void function with a string
     argument that is called whenever the user selects a file; the
     name of the selected file is passed to the callback function as
     its single argument. */

  DialogButton(Widget Parent, char *Name,
	       char *Message, DialogButtonCallback Callback);
};


/* SLIDER. */

typedef void (*SliderCallback)(float, void *);

class Slider {

 private:

  Widget Handle;
  SliderCallback Callback;
  void *UserData;

 public:

  /* Creates a slider as a child of the Parent widget. Name is the
     label that appears to the left and under the slider.  Minimum,
     Maximum, and InitialValue specify the minimum, maximum and
     starting values of the slider. These numbers are all integers. In
     order to display a slider that can range over floating point
     values, you provide the significant digits in the integer
     variables, and set Decimals to the number of the significant
     digits that should appear to the right of the decimal
     point. NewCallback is a void function that is called whenever the
     slider's position has been permanently changed (i.e. NOT while
     the slider is being dragged). The float argument passed to the
     callback contain the slider value exactly as displayed on the
     screen (i.e. the adjustment for significant digits and decimals
     has been taken care of). The second argument given to NewCallback
     is NewUserData. */

  Slider(Widget Parent, char *Name,
	 int Minimum, int Maximum, int InitialValue,
	 short Decimals, SliderCallback NewCallback, void *NewUserData =0);

  /* Sets the value of the receiver to Value. As the InitialValue
     argument of the Slider constructor, Value is an integer
     containing only the significant digits of the actual value. This
     method does not invoke the callback of the slider. */

  void SetValue(int Value) const;

  friend void SliderPrecallback(Widget, Slider *, void *);
};


typedef void (*ChoiceButtonCallback)(int);

class ChoiceButtonSet {

 private:

  Widget Row;

 public:

  /* Creates a choice button set as a child of the Parent widget.
     Name is the label that appears to the left of the set. Radio is a
     binary flag that when set (1) makes the choice button set a set
     of radio buttons; otherwise, when Radio is 0, the set contains
     check boxes. */

  ChoiceButtonSet(Widget Parent, char *Name, int Radio);

  /* Adds a choice button to the receiver. The label that appears
     within the button is Name. On is a binary flag that indicates the
     initial status of the button. Callback is a void function with
     one argument that is called whenever the button is activated; the
     argument indicates the new button status (1 if the button is now
     active, 0 if it was turned off). Note that the callback is NOT
     called when the buttons are created (i.e. when the buttons whose
     On field is 1 are initially turned on). */

  void AddButton(char *Name, int On, ChoiceButtonCallback Callback) const;
};

#endif
