//
//  Controller.h
//  SnoopX
//
//  Created by tzhuan on 2008/7/21.
//  Copyright 2008 NTU CSIE CMLAB. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "Snooper.h"
#import "HDRImageView.h"

@interface Controller : NSObject {
	IBOutlet NSWindow *window;
	IBOutlet HDRImageView *view; // HDR-capable MTKView-based image view
	IBOutlet NSTextField *status;

	NSMenuItem *currentGraph;
	IBOutlet NSMenuItem *graphOff;
	IBOutlet NSMenuItem *graphHoriStep;
	IBOutlet NSMenuItem *graphHoriLinear;
	IBOutlet NSMenuItem *graphVertStep;
	IBOutlet NSMenuItem *graphVertLinear;

	NSMenuItem *currentZoom;
	IBOutlet NSMenuItem *zoom1;
	IBOutlet NSMenuItem *zoom2;
	IBOutlet NSMenuItem *zoom3; // Disabled - problematic zoom level
	IBOutlet NSMenuItem *zoom4;
	IBOutlet NSMenuItem *zoom5; // Disabled - problematic zoom level
	IBOutlet NSMenuItem *zoom6; // Disabled - problematic zoom level
	IBOutlet NSMenuItem *zoom7; // Disabled - problematic zoom level
	IBOutlet NSMenuItem *zoom8;
	IBOutlet NSMenuItem *zoom9; // Disabled - problematic zoom level
	IBOutlet NSMenuItem *zoom10; // Disabled - problematic zoom level

	NSMenuItem *currentTimer;
	IBOutlet NSMenuItem *timerNone;
	IBOutlet NSMenuItem *timer50;
	IBOutlet NSMenuItem *timer100;
	IBOutlet NSMenuItem *timer200;
	IBOutlet NSMenuItem *timer500;
	IBOutlet NSMenuItem *timer1000;

	IBOutlet NSMenuItem *lockPosition;
	
	IBOutlet NSMenuItem *alwaysOnTop;

	IBOutlet NSMenuItem *highlight;

	IBOutlet NSMenuItem *statistics;
	IBOutlet NSMenuItem *swatch;

	NSMenuItem *currentDisplayMode;
	IBOutlet NSMenuItem *displayModeAuto;
	IBOutlet NSMenuItem *displayModeSDR;
	IBOutlet NSMenuItem *displayModeHDR;

	NSMenuItem *currentEDRMode;
	IBOutlet NSMenuItem *displayModeGammaEDR;
	IBOutlet NSMenuItem *displayModeLinearEDR;

	NSTimer *timer;
	Snooper *snooper;
	NSPoint cursor;

	NSEvent * (^keydownHandler)(NSEvent *);
	id keydownMonitorId;

	CGFloat maxBackingScaleFactor; // stored so keydown handler can use it
	int currentZoomLevel;          // tracks active zoom for '0' key toggle

	// Precision cursor tracking for sub-point nudging
	CGFloat precisionCursorX;     // AppKit coords, tracks 0.5-point (1-pixel) steps
	CGFloat precisionCursorY;
	BOOL didNudge;                 // YES if last position change was from a key nudge
}

-(IBAction)actGraph:(id)sender;
-(IBAction)actUpdate:(id)sender;
-(IBAction)actZoom:(id)sender;
-(IBAction)actTimer:(id)sender;
-(IBAction)actAlwaysOnTop:(id)sender;
-(IBAction)actHighlight:(id)sender;
-(IBAction)actStatistics:(id)sender;
-(IBAction)actSwatch:(id)sender;
-(IBAction)actLockPosition:(id)sender;
-(IBAction)actDisplayMode:(id)sender;

-(void)loadUserDefaults;

-(void)updateZoom:(int)zoom Sync:(BOOL)sync;
-(void)updateAlwaysOnTop:(BOOL)flag Sync:(BOOL)sync;
-(void)updateTimer:(int)freq Sync:(BOOL)sync;
-(void)updateGraph:(int)graph Sync:(BOOL)sync;
-(void)updateHighlight:(BOOL)flag Sync:(BOOL)sync;
-(void)updateStatistics:(BOOL)flag Sync:(BOOL)sync;
-(void)updateSwatch:(BOOL)flag Sync:(BOOL)sync;
-(void)updateLockPosition:(BOOL)flag Sync:(BOOL)sync;
-(void)updateDisplayMode:(int)mode Sync:(BOOL)sync;
-(void)updateEDRMode:(int)mode Sync:(BOOL)sync;

-(void)updateView;
-(void)stopTimer;
-(void)startTimer:(float)time;
@end
