//
//  HDRImageView.h
//  SnoopX
//
//  MTKView-based HDR display for Extended Dynamic Range content
//

#import <Cocoa/Cocoa.h>
#import <MetalKit/MetalKit.h>

@interface HDRImageView : MTKView <MTKViewDelegate>

// NSImageView-compatible API
@property (nonatomic, strong) NSImage *image;

// HDR-preserving API (preferred for HDR content)
- (void)setCGImage:(CGImageRef CF_RELEASES_ARGUMENT)cgImage;

// HDR configuration
@property (nonatomic, assign) BOOL enableHDR;

// Set YES for linear display color space (washed out, unclamped),
// NO for gamma-encoded (matches monitor appearance, clamped at EDR limit).
@property (nonatomic, assign) BOOL useLinearDisplayColorSpace;

@end
